<?php
require_once("JSON.php");

class actions {
	var $respuesta = array( "actions"=>array(), "data"=>array() );
	
	function add_action( $field, $action ) {
		global $respuesta;
		
		$respuesta['actions'][] = "$('#$field').$action;";
	}
	function add_js_code( $code ) {
		global $respuesta;
		
		$respuesta['actions'][] = $code;
	}
	// Para visualizar un alert
	function alert( $mensaje ) {
		global $respuesta;
		
		$mensaje	= utf8_encode(str_replace("'","\'",$mensaje));
		$respuesta['actions'][] = "alert('$mensaje');";
	}
	// Select para agregar opciones
	function addOption( $field, $value, $text, $selected=false ) {
		$op_value = ( isset($value) ? " value='$value'" : " value=''" );
		$selection = ( $selected ? " selected" : "" );
		$this->add_action( $field, "append(\"<option$op_value$selection>$text</option>\")");
	}
	// Select para quitar opciones
	function removeOption( $field, $value ) {
		$this->add_action( $field, "children(\"[@value='$value']\").remove()");
	}
	// Select para limpiar las opciones
	function clearOptions( $field ) {
		$this->add_action( $field, "empty()" );
	}
	// Para establecer el valor de un campo tipo input_text
	function text( $field , $value ) {
		$this->add_action( $field, "val('$value')" );
	}
	// Para establecer el valor de un campo tipo td
	function td_text( $field , $value ) {
		$this->add_action( $field, "text('$value')" );
	}
	// Para establecer checked en un checkbox
	function checked( $field, $value ) {
		$bool_value = ( $value ? "true" : "false" );
		$this->add_action( $field, "attr('checked',$bool_value)" );
	}
	// Para visualizar u ocultar el campo
	function visible( $field, $value ) {
		if ( $value )
			$this->add_action( $field, "show()" );
		else
			$this->add_action( $field, "hide()" );
	}
	// Deshabilita o habilita el campo
	function disable( $field, $value ) {
		$bool_value = ( $value ? "true" : "false" );
		$this->add_action( $field, "attr('disabled',$bool_value)" );
	}
	// Selecciona una opcion en un select
	function selectedOption( $field, $value, $trigged=true ) {
		$this->add_action( $field, "val('$value')" );
		if ($trigged) {
			$this->trigger( $field, "change" );
		}
	}
	// Selecciona una opcion (como selectedIndex) en un select
	function selectedIndex( $field, $value, $trigger=true ) {
		$this->add_action( $field, "attr('selectedIndex','$value')" );
		if ($trigger)
			$this->trigger( $field, "change" );
	}
	// Dispara un evento
	function trigger( $field, $value ) {
		$this->add_action( $field, "trigger('$value')" );
	}
	// Obtiene foco
	function focus( $field ) {
		$this->add_action( $field, "focus()" );
	}
	// Para el envio de la salida
	function send_response() {
		global $respuesta;
		
		///// JSON /////
		$json = new Services_JSON();
		echo $json->encode($respuesta);
	}
}
/*
// Quito las opciones invalidas
//jQuery($nombre)->children("option:first")->remove();
//jQuery($nombre)->children("option:eq(0)")->remove();
jQuery($nombre)->children("[@value='']")->remove();	// Filtra aquellas con valor invalido

jQuery::addMessage("Ocurrio un error durante la carga de informacion, por favor intente mas tarde");
jQuery('#Cliente_fxd')->trigger( "change" );

// En JavaScript
var $t = document.getElementById('tablaDinamica');
$($t).trigger("reloadGrid")
// es igual
$('#tablaDinamica').trigger("reloadGrid")
window.location = $('a#menu_crear').attr('href');	// Click para un objeto <a id="menu_crear" href=... </a>
*/
?>